---
sidebar_position: 1
title: Changelog
---

# Changelog

## Version 1.7.0 (30 July 2025)

<details>
<summary><strong>Added</strong></summary>

- **Online Exam System & MCQs Management**
  ![e-School SaaS](../static/images/changelog/bulk-mcq-question.png)
  ![e-School SaaS](../static/images/changelog/randomquestion.png)
  - Multiple question types support
  - Real-time exam monitoring
  - Bulk MCQs upload functionality
  - Random question assignment
  - Question difficulty levels (Easy, Medium, Hard)
  - Enhanced question bank organization

- **Assignment Submission Improvements**
  ![e-School SaaS](../static/images/changelog/bulk-assignment-sub.png)
  - Streamlined submission process
  - Better file management
  - Enhanced tracking system
  - Improved feedback mechanism

- **Multilingual Website Support**
  ![e-School SaaS](../static/images/changelog/multilanguage.png)
  - Multiple language support
  - Easy language switching
  - Customizable content per language
  - Improved accessibility

- **Fees Management Enhancement**
  ![e-School SaaS](../static/images/changelog/optionalfeesfilter.png)
  - Optional fees filter
  - Improved fee structure
  - Better tracking system
  - Enhanced reporting

</details>

<details>
<summary><strong>Improvements</strong></summary>

- **Exam Reports**
  - Refactored for better performance
  - Enhanced data visualization

- **Performance & Security**
  - Performance optimizations
  - Enhanced security measures
  - Bug fixes and stability improvements
  - System-wide performance enhancements

- **Other Enhancements**
  - General UI/UX improvements
  - System stability enhancements

</details>

## Version 1.6.0 (23 June 2025)

- **[Added]** - Session year and Semester wise manage data in school admin.
- **[Added]** - Reports :- 
                - Student Reports
                    - Attendance
                    - Offline Exam
                    - Online Exam
                    - Fees
                    - Student Yearly Exam Results
                - Exam Report :-
                    - Yearly Wise Results
                    - Subject Wise Results
                    - Rank Wise Results
- **[Added]** - Assign elective subjects to students in school admin.
- **[Added]** - Contact Inquiry in super admin and school
- **[Added]** - Add a filter dropdown to show Subjects based on the selected Class and Section.
- **[Added]** - 'Account' selection to Fees Instalment module.
- **[Improvements]** - School name display in browser tab
- **[Improvements]** - Privacy - Policy & Terms & Conditions
- **[Improvements]** - Domain URL appears on school edit screen.
- **[Improvements]** - Fixed issue with multiple students taking online exam simultaneously.
- **[Improvements]** - Fixed notification issue for attachments in chat (images/documents)
- **[Improvements]** - Auto-scroll to active sidebar item added for web panels.
- **[Improvements]** - School Admins can now enable and manage 2FA from their profile setting.
- **[Improvements]** - School Admin offline marks upload bug fixed.
- **[Improvements]** - Fixed subject selection in Online Exam.
- **[Improvements]** - Previously only staff showed — now both teachers and staff can be selected for ID Cards and Certificates.
- **[Improvements]** - Chat history now filters by both sender and receiver in Apps chat.
- **[Improvements]** - Fixed school logo duplication in landing page carouse.
- **[Improvements]** - Added standard ID card dimension messages (width: 100–105mm, height: 150–155mm).
- **[Improvements]** - Users can now drag events into the calendar. System also checks subject type compatibility to avoid conflicts with electives.
- **[Improvements]** - School website UI improvements.

## Version 1.5.5 (12 May 2025)

- **[Improvements]** Subscriptions Module Improvements

## Version 1.5.4 (22 April 2025)

- **[Added]** Wizard Settings  
- **[Added]** Paystack Payment Gateway Implementation  
- **[Added]** Flutterwave Payment Gateway Implementation  
- **[Improvements]** "Schools Details" → "Manage Schools" label updated in Super Admin panel for clarity  
- **[Improvements]** Common Subject Dropdown to standardize subject selection across modules  
- **[Improvements]** Restructured Permissions UI in both Super Admin & Admin panels for better UX  
- **[Improvements]** Timetable Edit Improved for easier, faster updates to schedules  
- **[Improvements]** Browser Tab School Name Fix for dynamic and accurate tab titles  
- **[Improvements]** Privacy Policy & Terms UI revamped for clearer structure  
- **[Improvements]** General UI/UX Enhancements and minor fixes throughout  
- **[Improvements]** Other Improvements

## Version 1.5.3 (21 Feb 2025)

- **[Improvements]** Send Notifications Checkbox in Student, Teacher, Staff Bulk Upload  
- **[Improvements]** School Edit: Assign Package Show/Hide in Super Admin  
- **[Improvements]** Select Image File on Change Validation Removed  
- **[Improvements]** Sample Service File and File Validation in Notification Settings  
- **[Improvements]** Overdue Fees Notification – Guardian Notification Issue  
- **[Improvements]** Notification Error When No Users Are Selected  
- **[Improvements]** Reset Button Not Working on Classes Field  
- **[Improvements]** Common Subject Dropdown Data Filter Issue  
- **[Improvements]** Warning Notification Condition in Student Bulk Upload  
- **[Improvements]** Assignment Notification Not Sent in Web Panel  
- **[Improvements]** Assignment Update Issue and Announcement Send Issue in Teacher App  
- **[Improvements]** Role-Wise Edit Condition in Announcement Edit  
- **[Improvements]** URL Validation in Assignment and Announcement  
- **[Improvements]** Other Improvements

## Version 1.5.2 (13 Feb 2025)

- **[Improvements]** Demo Schools functionality  
- **[Improvements]** 2FA-related bugs for Admins  
- **[Improvements]** School Inquiry feature  
- **[Improvements]** Multiple Class Selections for Uploading Assignments and Study Materials  
- **[Improvements]** Display logos for trashed and inactive schools  
- **[Improvements]** School logo not showing on the 2FA page  
- **[Improvements]** Hide extra fields for non-super admins on staff creation  
- **[Improvements]** Subject type display in the timetable  
- **[Improvements]** Web login restriction for Student/Guardian roles  
- **[Improvements]** Student and parent count issue in School Admin  
- **[Improvements]** 'Start Trial Package' checkbox and field visibility on login page  
- **[Improvements]** File upload validation in School Details and Feature section  
- **[Improvements]** Custom fields on Student Admission Form  
- **[Improvements]** Staff custom fields during creation  
- **[Improvements]** Overdue notifications in Custom Notification section  
- **[Improvements]** Wildcard domain validation and 400 Error handling  
- **[Improvements]** Exam Publish warning toast  
- **[Improvements]** Login issue for demo schools with 2FA enabled

## Version 1.5.1 (16 Jan 2025)

- **[Improvements]** Bugfixes in Demo Schools  
- **[Improvements]** Bugfixes related to 2FA for Admins  
- **[Improvements]** Bugfixes in School Inquiry feature  
- **[Improvements]** Bugfixes for Multiple Class Selections for Assignments and Study Materials  
- **[Improvements]** Other Improvements

## Version 1.5.0 (4 Jan 2025)

- **[Added]** Custom domain for school website  
- **[Added]** School data backup and import  
- **[Added]** Mark submission using CSV and reminder  
- **[Added]** Fee improvements  
- **[Added]** Staff and teacher additional fields  
- **[Added]** Lead generation or inquiry  
- **[Improved]** General Bugfixes and Improvements

## Version 1.4.1 (10 Oct 2024)

- **[Added]** Student admission form fields in ID card  
- **[Improvements]** Other Improvements

## Version 1.4.0 (30 Sept 2024)

- **[Added]** Online student admission form  
- **[Added]** Delete permanent data  
- **[Added]** Chat Feature  
- **[Added]** School-wise Separate database  
- **[Added]** School admin email verification  
- **[Added]** Google Captcha in school/student registration and contact forms  
- **[Added]** Sidebar menu search option  
- **[Added]** Super admin can email school admins  
- **[Added]** Login via email or mobile  
- **[Improvements]** Certificates module  
- **[Improvements]** Attendance month-wise student view

## Version 1.3.3 (18 July 2024)

- **[Added]** Razorpay payment gateway (Fees & Subscription Modules)  
- **[Improvement]** Other Improvements

## Version 1.3.2 (29 June 2024)

- **[Added]** School Website - Custom School Domain  
- **[Added]** Custom Email Template  
- **[Added]** Generate Certificates for Students & Staff  
- **[Added]** Staff ID Card  
- **[Added]** Student Result PDF  
- **[Added]** Bulk Staff & Teacher Upload  
- **[Added]** Class Group  
- **[Added]** Result download for Students/Staff  
- **[Improvement]** Payroll: Add Allowances & Deductions  
- **[Improvement]** Partial Fee Payment with Remaining Balance Receipt  
- **[Improvement]** Other Improvements

## Version 1.3.1 (27 May 2024)

- **[Updated]** Firebase cloud message deprecated version updated  
- **[Updated]** App codes updated to Flutter 3.22.0  
- **[Improvement]** Bugfixes and Improvements

## Version 1.3.0 (14 May 2024)

- **[Added]** Staff-Teacher Application  
- **[Added]** Prepaid school subscription plan  
- **[Added]** Student ID card with dynamic settings  
- **[Added]** User-wise default language  
- **[Added]** Password reset from admin panel  
- **[Added]** Guardian notifications on fee creation  
- **[Added]** Staff-wise leave report in admin panel  
- **[Added]** Exam timetable view for subject teachers  
- **[Added]** Notification to guardian of absent student  
- **[Improvement]** School & super admin dashboard  
- **[Improvement]** RTL layout support  
- **[Improvement]** Subject-teacher wise data fetching  
- **[Improvement]** Notification  
- **[Improvement]** Semester system

## Version 1.2.1 (29 Mar 2024)

- **[Fixed]** Assignment resubmission issue  
- **[Fixed]** Online exam answer submission issue  
- **[Fixed]** Due date issue in fee module  
- **[Fixed]** iOS notification issue  
- **[Added]** Other Improvements

## Version 1.2.0 (5 Mar 2024)

- **[Added]** Send Notification System  
- **[Added]** School Gallery  
- **[Added]** Cash/Cheque Payment for Subscriptions in Super Admin  
- **[Added]** Staff salary slip generation  
- **[Added]** Fees statistics  
- **[Added]** Bulk upload profile images for student & guardian  
- **[Added]** Fees Due Charges Type: Fixed / Percentage  
- **[Added]** Date Format Option  
- **[Improvement]** Billing cycle days (package wise)  
- **[Improvement]** Subscription code optimization  
- **[Improvement]** Allow staff to update profile  
- **[Improvement]** Extra filters for table data  
- **[Improvement]** Landing page design updated  
- **[Fix]** Fees calculation with due charges  
- **[Fix]** Table export option added

## Version 1.1.1 (2 Feb 2024)

- **[Improved]** Subscription billing calculation  
- **[Added]** Feature names in language translations  
- **[Fixed]** Student update issue on custom file field upload

## Version 1.1.0 (25 Jan 2024)

- **[Added]** Fees Module  
- **[Added]** Staff Leave Management  
- **[Added]** Staff Payroll Management  
- **[Added]** Guidance links on Landing Page  
- **[Improvement]** Multilingual Landing Page  
- **[Improvement]** Subscription Management (Super & School Admin)  
- **[Improvement]** School Dashboard: Expense & Class Section Attendance Graph

## Version 1.0.1 (1 Dec 2023)

- **[Added]** Landing Page Customization  
- **[Added]** Data deletion protection if linked to other data  
- **[Improvements]** Minor issues fixed
