@extends('layouts.master')

@section('title')
    {{ __('manage') . ' ' . __('assignment') }}
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                {{ __('manage') . ' ' . __('assignment_submission') }}
            </h3>
        </div>
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">
                            {{ __('list') . ' ' . __('assignment_submission') }}
                        </h4>

                        <div class="row" id="toolbar">

                            <div class="col-12 col-sm-12 col-md-3 col-lg-6">
                                <label for="filter-class-section-id" class="filter-menu">{{__("class_section")}}</label>
                                <select name="class_section_id" id="filter-class-section-id" class="form-control" style="width:100%;" tabindex="-1" aria-hidden="true">
                                    <option value="">{{ __('all') }}</option>
                                    @foreach ($classSections as $data)
                                        <option value="{{ $data->id }}">
                                            {{ $data->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-12 col-sm-12 col-md-3 col-lg-6">
                                <label for="filter_subject_id" class="filter-menu">{{__("subject")}}</label>
                                <select name="class_subject_id" id="filter-subject-id" class="form-control select2" style="width:100%;" tabindex="-1" aria-hidden="true">
                                    <option value="">-- {{ __('Select Subject') }} --</option>
                                    {{-- <option value="data-not-found">-- {{ __('no_data_found') }} --</option> --}}
                                    @foreach ($subjectTeachers as $item)
                                        <option value="{{ $item->class_subject_id }}" data-class-section="{{ $item->class_section_id }}">{{ $item->subject_with_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                        </div>
                        <table aria-describedby="mydesc" class='table table-striped' id='table_list' data-toggle="table"
                               data-url="{{ route('assignment.submission.list') }}" data-click-to-select="true"
                               data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 20, 50, 100, 200]"
                               data-search="true" data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true"
                               data-fixed-columns="true" data-fixed-number="2" data-fixed-right-number="1"
                               data-trim-on-search="false" data-mobile-responsive="true" data-sort-name="id"
                               data-query-params="AssignmentSubmissionQueryParams" data-sort-order="desc"
                               data-maintain-selected="true" data-export-types='["txt","excel"]'
                               data-export-options='{ "fileName": "assignment-submission-list-<?= date('d-m-y') ?>","ignoreColumn": ["operate"]}'
                               data-show-export="true">
                            <thead>
                            <tr>
                                <th scope="col" data-field="id" data-sortable="true" data-visible="false">{{ __('id') }}</th>
                                <th scope="col" data-field="no">{{ __('no.') }}</th>
                                <th scope="col" data-field="assignment.name" data-sortable="true">{{ __('assignment_name') }}</th>
                                <th scope="col" data-field="assignment.class_section.full_name" data-sortable="true">{{ __('class_section') }}</th>
                                <th scope="col" data-field="assignment.class_subject.subject.name_with_type" data-sortable="true">{{ __('subject') }}</th>
                                <th scope="col" data-field="student.full_name" data-sortable="true">{{ __('student_name') }}</th>
                                <th scope="col" data-field="file" data-sortable="true" data-formatter="fileFormatter">{{ __('files') }}</th>
                                <th scope="col" data-field="status" data-sortable="true" data-formatter="assignmentSubmissionStatusFormatter">{{ __('status') }}</th>
                                <th scope="col" data-field="assignment.points" data-sortable="true">{{ __('points') }}</th>
                                <th scope="col" data-field="feedback" data-sortable="true">{{ __('feedback') }}</th>
                                <th scope="col" data-field="session_year.name" data-sortable="true" data-visible="false">{{ __('Session Year') }}</th>
                                <th scope="col" data-field="created_at" data-sortable="true" data-visible="false">{{ __('created_at') }}</th>
                                <th scope="col" data-field="updated_at" data-sortable="true" data-visible="false">{{ __('updated_at') }}</th>
                                <th scope="col" data-field="operate" data-events="assignmentSubmissionEvents">{{ __('action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                 aria-hidden="true">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">
                                {{ __('edit') . ' ' . __('assignment_submission') }}
                            </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form class="pt-3 class-edit-form" id="edit-form" action="{{ url('assignment-submission') }}" novalidate="novalidate">
                            <input type="hidden" name="edit_id" id="edit_id" value=""/>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>{{ __('assignment_name') }}</label>
                                    <input type="text" name="" id="assignment_name" class="form-control" disabled>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('subject') }}</label>
                                    <input type="text" name="" id="subject" class="form-control" disabled>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('student_name') }}</label>
                                    <input type="text" name="" id="student_name" class="form-control" disabled>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('files') }}</label>
                                    <div id="files"></div>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('status') }} <span class="text-danger">*</span></label>
                                    <div class="d-flex">
                                        <div class="form-check form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input edit-status" name="status" id="status_accept" value="1">{{ __('accept') }}
                                            </label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" class="form-check-input edit-status" name="status" id="status_reject" value="2">{{ __('reject') }}
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group" id="points_div">
                                    <label>{{ __('points') }} <span id="assignment_points"></span></label>
                                    <input type="number" name="points" id="points" class="form-control" min="0">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('feedback') }}</label>
                                    {!! Form::textarea('feedback', null, ['class' => 'form-control', 'id' => 'feedback']) !!}
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('close') }}</button>
                                <input class="btn btn-theme" type="submit" value={{ __('edit') }} />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
